/*
 * Castaway
 *  (C) 1994 - 2002 Martin Doering, Joachim Hoenig
 *
 * $File$ - 68k subtract instructions
 *
 * This file is distributed under the GPL, version 2 or at your
 * option any later version.  See doc/license.txt for details.
 *
 * revision history
 *  23.05.2002  JH  FAST1.0.1 code import: KR -> ANSI, restructuring
 *  10.07.2002  JH  Fixed Z-Flag for SUBX
 *  08.10.2002  JH  Fixed Z-Flag for ADD.B 0x80+0x80 and Add.W 0x8000+0x8000.
 *  30.10.2002  JH  Replaced "% 8" with "& 7". Helps lesser compilers to generate faster code.
 */
#ifndef PROTOH
static char     sccsid[] = "$Id: op68ksub.c,v 1.4 2002/10/30 16:23:06 jhoenig Exp $";
#include "68000.h"
#include "op68k.h"

/*
 * Opfuncs.
 */

#define DoSubB(target,source) \
    {register int32 tgt;\
    tgt = target - source;\
    SetXC((uint32) source > (uint32) target);\
    SetV((tgt < -128) || (tgt > 127));\
    target = tgt;\
    SetNZ(target);};
#define DoSubW(target,source) \
    {register int32 tgt;\
    tgt = target - source;\
    SetXC((uint32) source > (uint32) target);\
    SetV((tgt < -32768) || (tgt > 32767));\
    target = tgt;\
    SetNZ(target);};
#define DoSubL(target,source) \
    /* Overflow precondition: source has different sign */\
    SetV((target < 0) != (source < 0));\
    SetXC((uint32) source > (uint32) target);\
    target -= source;\
    /* target and source now have same sign: overflow! */\
    SetV(GetV() && (target<0) == (source<0));\
    SetNZ(target);

#define DoSuba(target,source) target -= source;

#define DoSubx(target,source) \
    /* Overflow precondition: source has different sign */\
    SetV ((target < 0) != (source < 0));\
    if (GetX ()) {\
        SetXC ((uint32) source >= (uint32) target);\
        target -= source;\
        target -= 1;\
    } else {\
        SetXC ((uint32) source > (uint32) target);\
        target -= source;\
    }\
    /* target and source now have same sign: overflow! */\
    SetV (GetV() && (target<0) == (source<0));\
    SetZ(target == 0 ? GetZ() : 0);\
    SetN(target < 0);

#endif

Oper (Op9000, DoSubB, DB, SdB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op9010, DoSubB, DB, SainB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op9018, DoSubB, DB, SaipB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op9020, DoSubB, DB, SmaiB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op9028, DoSubB, DB, SdaiB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op9030, DoSubB, DB, SaixB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op9038, DoSubB, DB, SearB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op9040, DoSubW, DW, SdW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op9048, DoSubW, DW, SaW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op9050, DoSubW, DW, SainW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op9058, DoSubW, DW, SaipW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op9060, DoSubW, DW, SmaiW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op9068, DoSubW, DW, SdaiW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op9070, DoSubW, DW, SaixW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op9078, DoSubW, DW, SearW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op9080, DoSubL, DL, SdL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op9088, DoSubL, DL, SaL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op9090, DoSubL, DL, SainL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op9098, DoSubL, DL, SaipL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op90a0, DoSubL, DL, SmaiL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op90a8, DoSubL, DL, SdaiL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op90b0, DoSubL, DL, SaixL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op90b8, DoSubL, DL, SearL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op90c0, DoSuba, DL, SdW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op90c8, DoSuba, DL, SaW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op90d0, DoSuba, DL, SainW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op90d8, DoSuba, DL, SaipW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op90e0, DoSuba, DL, SmaiW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op90e8, DoSuba, DL, SdaiW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op90f0, DoSuba, DL, SaixW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op90f8, DoSuba, DL, SearW, (inst & 7), DL, DR, Ca, 0, GRL, SRL)

Oper (Op9100, DoSubx, DB, SdB, (inst & 7), DB, DR, Cd, 0, GRB, SRB)
Oper (Op9108, DoSubx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 0, GMB, SMB)
Oper (Op9110, DoSubB, DB, SdB, 0, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op9118, DoSubB, DB, SdB, 0, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op9120, DoSubB, DB, SdB, 0, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op9128, DoSubB, DB, SdB, 0, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op9130, DoSubB, DB, SdB, 0, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op9138, DoSubB, DB, SdB, 0, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op9140, DoSubx, DW, SdW, (inst & 7), DW, DR, Cd, 0, GRW, SRW)
Oper (Op9148, DoSubx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 0, GMW, SMW)
Oper (Op9150, DoSubW, DW, SdW, 0, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op9158, DoSubW, DW, SdW, 0, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op9160, DoSubW, DW, SdW, 0, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op9168, DoSubW, DW, SdW, 0, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op9170, DoSubW, DW, SdW, 0, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op9178, DoSubW, DW, SdW, 0, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op9180, DoSubx, DL, SdL, (inst & 7), DL, DR, Cd, 0, GRL, SRL)
Oper (Op9188, DoSubx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 0, GML, SML)
Oper (Op9190, DoSubL, DL, SdL, 0, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op9198, DoSubL, DL, SdL, 0, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op91a0, DoSubL, DL, SdL, 0, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op91a8, DoSubL, DL, SdL, 0, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op91b0, DoSubL, DL, SdL, 0, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op91b8, DoSubL, DL, SdL, 0, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Op91c0, DoSuba, DL, SdL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op91c8, DoSuba, DL, SaL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op91d0, DoSuba, DL, SainL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op91d8, DoSuba, DL, SaipL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op91e0, DoSuba, DL, SmaiL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op91e8, DoSuba, DL, SdaiL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op91f0, DoSuba, DL, SaixL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)
Oper (Op91f8, DoSuba, DL, SearL, (inst & 7), DL, DR, Ca, 0, GRL, SRL)

Oper (Op9200, DoSubB, DB, SdB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op9210, DoSubB, DB, SainB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op9218, DoSubB, DB, SaipB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op9220, DoSubB, DB, SmaiB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op9228, DoSubB, DB, SdaiB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op9230, DoSubB, DB, SaixB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op9238, DoSubB, DB, SearB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op9240, DoSubW, DW, SdW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op9248, DoSubW, DW, SaW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op9250, DoSubW, DW, SainW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op9258, DoSubW, DW, SaipW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op9260, DoSubW, DW, SmaiW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op9268, DoSubW, DW, SdaiW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op9270, DoSubW, DW, SaixW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op9278, DoSubW, DW, SearW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op9280, DoSubL, DL, SdL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op9288, DoSubL, DL, SaL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op9290, DoSubL, DL, SainL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op9298, DoSubL, DL, SaipL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op92a0, DoSubL, DL, SmaiL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op92a8, DoSubL, DL, SdaiL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op92b0, DoSubL, DL, SaixL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op92b8, DoSubL, DL, SearL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op92c0, DoSuba, DL, SdW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op92c8, DoSuba, DL, SaW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op92d0, DoSuba, DL, SainW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op92d8, DoSuba, DL, SaipW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op92e0, DoSuba, DL, SmaiW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op92e8, DoSuba, DL, SdaiW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op92f0, DoSuba, DL, SaixW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op92f8, DoSuba, DL, SearW, (inst & 7), DL, DR, Ca, 1, GRL, SRL)

Oper (Op9300, DoSubx, DB, SdB, (inst & 7), DB, DR, Cd, 1, GRB, SRB)
Oper (Op9308, DoSubx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 1, GMB, SMB)
Oper (Op9310, DoSubB, DB, SdB, 1, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op9318, DoSubB, DB, SdB, 1, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op9320, DoSubB, DB, SdB, 1, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op9328, DoSubB, DB, SdB, 1, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op9330, DoSubB, DB, SdB, 1, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op9338, DoSubB, DB, SdB, 1, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op9340, DoSubx, DW, SdW, (inst & 7), DW, DR, Cd, 1, GRW, SRW)
Oper (Op9348, DoSubx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 1, GMW, SMW)
Oper (Op9350, DoSubW, DW, SdW, 1, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op9358, DoSubW, DW, SdW, 1, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op9360, DoSubW, DW, SdW, 1, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op9368, DoSubW, DW, SdW, 1, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op9370, DoSubW, DW, SdW, 1, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op9378, DoSubW, DW, SdW, 1, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op9380, DoSubx, DL, SdL, (inst & 7), DL, DR, Cd, 1, GRL, SRL)
Oper (Op9388, DoSubx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 1, GML, SML)
Oper (Op9390, DoSubL, DL, SdL, 1, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op9398, DoSubL, DL, SdL, 1, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op93a0, DoSubL, DL, SdL, 1, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op93a8, DoSubL, DL, SdL, 1, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op93b0, DoSubL, DL, SdL, 1, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op93b8, DoSubL, DL, SdL, 1, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Op93c0, DoSuba, DL, SdL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op93c8, DoSuba, DL, SaL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op93d0, DoSuba, DL, SainL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op93d8, DoSuba, DL, SaipL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op93e0, DoSuba, DL, SmaiL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op93e8, DoSuba, DL, SdaiL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op93f0, DoSuba, DL, SaixL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)
Oper (Op93f8, DoSuba, DL, SearL, (inst & 7), DL, DR, Ca, 1, GRL, SRL)

Oper (Op9400, DoSubB, DB, SdB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op9410, DoSubB, DB, SainB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op9418, DoSubB, DB, SaipB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op9420, DoSubB, DB, SmaiB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op9428, DoSubB, DB, SdaiB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op9430, DoSubB, DB, SaixB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op9438, DoSubB, DB, SearB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op9440, DoSubW, DW, SdW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op9448, DoSubW, DW, SaW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op9450, DoSubW, DW, SainW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op9458, DoSubW, DW, SaipW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op9460, DoSubW, DW, SmaiW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op9468, DoSubW, DW, SdaiW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op9470, DoSubW, DW, SaixW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op9478, DoSubW, DW, SearW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op9480, DoSubL, DL, SdL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op9488, DoSubL, DL, SaL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op9490, DoSubL, DL, SainL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op9498, DoSubL, DL, SaipL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op94a0, DoSubL, DL, SmaiL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op94a8, DoSubL, DL, SdaiL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op94b0, DoSubL, DL, SaixL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op94b8, DoSubL, DL, SearL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op94c0, DoSuba, DL, SdW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op94c8, DoSuba, DL, SaW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op94d0, DoSuba, DL, SainW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op94d8, DoSuba, DL, SaipW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op94e0, DoSuba, DL, SmaiW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op94e8, DoSuba, DL, SdaiW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op94f0, DoSuba, DL, SaixW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op94f8, DoSuba, DL, SearW, (inst & 7), DL, DR, Ca, 2, GRL, SRL)

Oper (Op9500, DoSubx, DB, SdB, (inst & 7), DB, DR, Cd, 2, GRB, SRB)
Oper (Op9508, DoSubx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 2, GMB, SMB)
Oper (Op9510, DoSubB, DB, SdB, 2, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op9518, DoSubB, DB, SdB, 2, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op9520, DoSubB, DB, SdB, 2, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op9528, DoSubB, DB, SdB, 2, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op9530, DoSubB, DB, SdB, 2, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op9538, DoSubB, DB, SdB, 2, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op9540, DoSubx, DW, SdW, (inst & 7), DW, DR, Cd, 2, GRW, SRW)
Oper (Op9548, DoSubx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 2, GMW, SMW)
Oper (Op9550, DoSubW, DW, SdW, 2, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op9558, DoSubW, DW, SdW, 2, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op9560, DoSubW, DW, SdW, 2, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op9568, DoSubW, DW, SdW, 2, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op9570, DoSubW, DW, SdW, 2, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op9578, DoSubW, DW, SdW, 2, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op9580, DoSubx, DL, SdL, (inst & 7), DL, DR, Cd, 2, GRL, SRL)
Oper (Op9588, DoSubx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 2, GML, SML)
Oper (Op9590, DoSubL, DL, SdL, 2, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op9598, DoSubL, DL, SdL, 2, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op95a0, DoSubL, DL, SdL, 2, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op95a8, DoSubL, DL, SdL, 2, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op95b0, DoSubL, DL, SdL, 2, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op95b8, DoSubL, DL, SdL, 2, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Op95c0, DoSuba, DL, SdL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op95c8, DoSuba, DL, SaL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op95d0, DoSuba, DL, SainL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op95d8, DoSuba, DL, SaipL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op95e0, DoSuba, DL, SmaiL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op95e8, DoSuba, DL, SdaiL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op95f0, DoSuba, DL, SaixL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)
Oper (Op95f8, DoSuba, DL, SearL, (inst & 7), DL, DR, Ca, 2, GRL, SRL)

Oper (Op9600, DoSubB, DB, SdB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op9610, DoSubB, DB, SainB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op9618, DoSubB, DB, SaipB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op9620, DoSubB, DB, SmaiB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op9628, DoSubB, DB, SdaiB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op9630, DoSubB, DB, SaixB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op9638, DoSubB, DB, SearB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op9640, DoSubW, DW, SdW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op9648, DoSubW, DW, SaW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op9650, DoSubW, DW, SainW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op9658, DoSubW, DW, SaipW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op9660, DoSubW, DW, SmaiW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op9668, DoSubW, DW, SdaiW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op9670, DoSubW, DW, SaixW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op9678, DoSubW, DW, SearW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op9680, DoSubL, DL, SdL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op9688, DoSubL, DL, SaL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op9690, DoSubL, DL, SainL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op9698, DoSubL, DL, SaipL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op96a0, DoSubL, DL, SmaiL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op96a8, DoSubL, DL, SdaiL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op96b0, DoSubL, DL, SaixL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op96b8, DoSubL, DL, SearL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op96c0, DoSuba, DL, SdW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op96c8, DoSuba, DL, SaW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op96d0, DoSuba, DL, SainW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op96d8, DoSuba, DL, SaipW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op96e0, DoSuba, DL, SmaiW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op96e8, DoSuba, DL, SdaiW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op96f0, DoSuba, DL, SaixW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op96f8, DoSuba, DL, SearW, (inst & 7), DL, DR, Ca, 3, GRL, SRL)

Oper (Op9700, DoSubx, DB, SdB, (inst & 7), DB, DR, Cd, 3, GRB, SRB)
Oper (Op9708, DoSubx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 3, GMB, SMB)
Oper (Op9710, DoSubB, DB, SdB, 3, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op9718, DoSubB, DB, SdB, 3, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op9720, DoSubB, DB, SdB, 3, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op9728, DoSubB, DB, SdB, 3, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op9730, DoSubB, DB, SdB, 3, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op9738, DoSubB, DB, SdB, 3, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op9740, DoSubx, DW, SdW, (inst & 7), DW, DR, Cd, 3, GRW, SRW)
Oper (Op9748, DoSubx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 3, GMW, SMW)
Oper (Op9750, DoSubW, DW, SdW, 3, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op9758, DoSubW, DW, SdW, 3, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op9760, DoSubW, DW, SdW, 3, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op9768, DoSubW, DW, SdW, 3, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op9770, DoSubW, DW, SdW, 3, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op9778, DoSubW, DW, SdW, 3, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op9780, DoSubx, DL, SdL, (inst & 7), DL, DR, Cd, 3, GRL, SRL)
Oper (Op9788, DoSubx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 3, GML, SML)
Oper (Op9790, DoSubL, DL, SdL, 3, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op9798, DoSubL, DL, SdL, 3, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op97a0, DoSubL, DL, SdL, 3, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op97a8, DoSubL, DL, SdL, 3, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op97b0, DoSubL, DL, SdL, 3, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op97b8, DoSubL, DL, SdL, 3, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Op97c0, DoSuba, DL, SdL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op97c8, DoSuba, DL, SaL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op97d0, DoSuba, DL, SainL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op97d8, DoSuba, DL, SaipL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op97e0, DoSuba, DL, SmaiL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op97e8, DoSuba, DL, SdaiL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op97f0, DoSuba, DL, SaixL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)
Oper (Op97f8, DoSuba, DL, SearL, (inst & 7), DL, DR, Ca, 3, GRL, SRL)

Oper (Op9800, DoSubB, DB, SdB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op9810, DoSubB, DB, SainB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op9818, DoSubB, DB, SaipB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op9820, DoSubB, DB, SmaiB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op9828, DoSubB, DB, SdaiB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op9830, DoSubB, DB, SaixB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op9838, DoSubB, DB, SearB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op9840, DoSubW, DW, SdW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op9848, DoSubW, DW, SaW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op9850, DoSubW, DW, SainW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op9858, DoSubW, DW, SaipW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op9860, DoSubW, DW, SmaiW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op9868, DoSubW, DW, SdaiW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op9870, DoSubW, DW, SaixW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op9878, DoSubW, DW, SearW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op9880, DoSubL, DL, SdL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op9888, DoSubL, DL, SaL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op9890, DoSubL, DL, SainL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op9898, DoSubL, DL, SaipL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op98a0, DoSubL, DL, SmaiL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op98a8, DoSubL, DL, SdaiL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op98b0, DoSubL, DL, SaixL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op98b8, DoSubL, DL, SearL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op98c0, DoSuba, DL, SdW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op98c8, DoSuba, DL, SaW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op98d0, DoSuba, DL, SainW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op98d8, DoSuba, DL, SaipW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op98e0, DoSuba, DL, SmaiW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op98e8, DoSuba, DL, SdaiW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op98f0, DoSuba, DL, SaixW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op98f8, DoSuba, DL, SearW, (inst & 7), DL, DR, Ca, 4, GRL, SRL)

Oper (Op9900, DoSubx, DB, SdB, (inst & 7), DB, DR, Cd, 4, GRB, SRB)
Oper (Op9908, DoSubx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 4, GMB, SMB)
Oper (Op9910, DoSubB, DB, SdB, 4, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op9918, DoSubB, DB, SdB, 4, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op9920, DoSubB, DB, SdB, 4, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op9928, DoSubB, DB, SdB, 4, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op9930, DoSubB, DB, SdB, 4, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op9938, DoSubB, DB, SdB, 4, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op9940, DoSubx, DW, SdW, (inst & 7), DW, DR, Cd, 4, GRW, SRW)
Oper (Op9948, DoSubx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 4, GMW, SMW)
Oper (Op9950, DoSubW, DW, SdW, 4, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op9958, DoSubW, DW, SdW, 4, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op9960, DoSubW, DW, SdW, 4, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op9968, DoSubW, DW, SdW, 4, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op9970, DoSubW, DW, SdW, 4, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op9978, DoSubW, DW, SdW, 4, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op9980, DoSubx, DL, SdL, (inst & 7), DL, DR, Cd, 4, GRL, SRL)
Oper (Op9988, DoSubx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 4, GML, SML)
Oper (Op9990, DoSubL, DL, SdL, 4, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op9998, DoSubL, DL, SdL, 4, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op99a0, DoSubL, DL, SdL, 4, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op99a8, DoSubL, DL, SdL, 4, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op99b0, DoSubL, DL, SdL, 4, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op99b8, DoSubL, DL, SdL, 4, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Op99c0, DoSuba, DL, SdL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op99c8, DoSuba, DL, SaL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op99d0, DoSuba, DL, SainL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op99d8, DoSuba, DL, SaipL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op99e0, DoSuba, DL, SmaiL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op99e8, DoSuba, DL, SdaiL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op99f0, DoSuba, DL, SaixL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)
Oper (Op99f8, DoSuba, DL, SearL, (inst & 7), DL, DR, Ca, 4, GRL, SRL)

Oper (Op9a00, DoSubB, DB, SdB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op9a10, DoSubB, DB, SainB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op9a18, DoSubB, DB, SaipB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op9a20, DoSubB, DB, SmaiB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op9a28, DoSubB, DB, SdaiB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op9a30, DoSubB, DB, SaixB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op9a38, DoSubB, DB, SearB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op9a40, DoSubW, DW, SdW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op9a48, DoSubW, DW, SaW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op9a50, DoSubW, DW, SainW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op9a58, DoSubW, DW, SaipW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op9a60, DoSubW, DW, SmaiW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op9a68, DoSubW, DW, SdaiW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op9a70, DoSubW, DW, SaixW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op9a78, DoSubW, DW, SearW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op9a80, DoSubL, DL, SdL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op9a88, DoSubL, DL, SaL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op9a90, DoSubL, DL, SainL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op9a98, DoSubL, DL, SaipL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op9aa0, DoSubL, DL, SmaiL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op9aa8, DoSubL, DL, SdaiL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op9ab0, DoSubL, DL, SaixL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op9ab8, DoSubL, DL, SearL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op9ac0, DoSuba, DL, SdW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9ac8, DoSuba, DL, SaW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9ad0, DoSuba, DL, SainW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9ad8, DoSuba, DL, SaipW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9ae0, DoSuba, DL, SmaiW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9ae8, DoSuba, DL, SdaiW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9af0, DoSuba, DL, SaixW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9af8, DoSuba, DL, SearW, (inst & 7), DL, DR, Ca, 5, GRL, SRL)

Oper (Op9b00, DoSubx, DB, SdB, (inst & 7), DB, DR, Cd, 5, GRB, SRB)
Oper (Op9b08, DoSubx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 5, GMB, SMB)
Oper (Op9b10, DoSubB, DB, SdB, 5, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op9b18, DoSubB, DB, SdB, 5, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op9b20, DoSubB, DB, SdB, 5, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op9b28, DoSubB, DB, SdB, 5, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op9b30, DoSubB, DB, SdB, 5, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op9b38, DoSubB, DB, SdB, 5, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op9b40, DoSubx, DW, SdW, (inst & 7), DW, DR, Cd, 5, GRW, SRW)
Oper (Op9b48, DoSubx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 5, GMW, SMW)
Oper (Op9b50, DoSubW, DW, SdW, 5, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op9b58, DoSubW, DW, SdW, 5, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op9b60, DoSubW, DW, SdW, 5, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op9b68, DoSubW, DW, SdW, 5, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op9b70, DoSubW, DW, SdW, 5, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op9b78, DoSubW, DW, SdW, 5, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op9b80, DoSubx, DL, SdL, (inst & 7), DL, DR, Cd, 5, GRL, SRL)
Oper (Op9b88, DoSubx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 5, GML, SML)
Oper (Op9b90, DoSubL, DL, SdL, 5, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op9b98, DoSubL, DL, SdL, 5, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op9ba0, DoSubL, DL, SdL, 5, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op9ba8, DoSubL, DL, SdL, 5, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op9bb0, DoSubL, DL, SdL, 5, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op9bb8, DoSubL, DL, SdL, 5, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Op9bc0, DoSuba, DL, SdL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9bc8, DoSuba, DL, SaL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9bd0, DoSuba, DL, SainL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9bd8, DoSuba, DL, SaipL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9be0, DoSuba, DL, SmaiL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9be8, DoSuba, DL, SdaiL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9bf0, DoSuba, DL, SaixL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)
Oper (Op9bf8, DoSuba, DL, SearL, (inst & 7), DL, DR, Ca, 5, GRL, SRL)

Oper (Op9c00, DoSubB, DB, SdB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op9c10, DoSubB, DB, SainB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op9c18, DoSubB, DB, SaipB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op9c20, DoSubB, DB, SmaiB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op9c28, DoSubB, DB, SdaiB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op9c30, DoSubB, DB, SaixB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op9c38, DoSubB, DB, SearB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op9c40, DoSubW, DW, SdW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op9c48, DoSubW, DW, SaW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op9c50, DoSubW, DW, SainW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op9c58, DoSubW, DW, SaipW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op9c60, DoSubW, DW, SmaiW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op9c68, DoSubW, DW, SdaiW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op9c70, DoSubW, DW, SaixW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op9c78, DoSubW, DW, SearW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op9c80, DoSubL, DL, SdL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op9c88, DoSubL, DL, SaL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op9c90, DoSubL, DL, SainL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op9c98, DoSubL, DL, SaipL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op9ca0, DoSubL, DL, SmaiL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op9ca8, DoSubL, DL, SdaiL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op9cb0, DoSubL, DL, SaixL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op9cb8, DoSubL, DL, SearL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op9cc0, DoSuba, DL, SdW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9cc8, DoSuba, DL, SaW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9cd0, DoSuba, DL, SainW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9cd8, DoSuba, DL, SaipW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9ce0, DoSuba, DL, SmaiW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9ce8, DoSuba, DL, SdaiW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9cf0, DoSuba, DL, SaixW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9cf8, DoSuba, DL, SearW, (inst & 7), DL, DR, Ca, 6, GRL, SRL)

Oper (Op9d00, DoSubx, DB, SdB, (inst & 7), DB, DR, Cd, 6, GRB, SRB)
Oper (Op9d08, DoSubx, DB, SmaiB, (inst & 7), DB, DA, CmaiB, 6, GMB, SMB)
Oper (Op9d10, DoSubB, DB, SdB, 6, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op9d18, DoSubB, DB, SdB, 6, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op9d20, DoSubB, DB, SdB, 6, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op9d28, DoSubB, DB, SdB, 6, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op9d30, DoSubB, DB, SdB, 6, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op9d38, DoSubB, DB, SdB, 6, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op9d40, DoSubx, DW, SdW, (inst & 7), DW, DR, Cd, 6, GRW, SRW)
Oper (Op9d48, DoSubx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 6, GMW, SMW)
Oper (Op9d50, DoSubW, DW, SdW, 6, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op9d58, DoSubW, DW, SdW, 6, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op9d60, DoSubW, DW, SdW, 6, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op9d68, DoSubW, DW, SdW, 6, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op9d70, DoSubW, DW, SdW, 6, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op9d78, DoSubW, DW, SdW, 6, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op9d80, DoSubx, DL, SdL, (inst & 7), DL, DR, Cd, 6, GRL, SRL)
Oper (Op9d88, DoSubx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 6, GML, SML)
Oper (Op9d90, DoSubL, DL, SdL, 6, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op9d98, DoSubL, DL, SdL, 6, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op9da0, DoSubL, DL, SdL, 6, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op9da8, DoSubL, DL, SdL, 6, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op9db0, DoSubL, DL, SdL, 6, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op9db8, DoSubL, DL, SdL, 6, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Op9dc0, DoSuba, DL, SdL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9dc8, DoSuba, DL, SaL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9dd0, DoSuba, DL, SainL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9dd8, DoSuba, DL, SaipL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9de0, DoSuba, DL, SmaiL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9de8, DoSuba, DL, SdaiL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9df0, DoSuba, DL, SaixL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)
Oper (Op9df8, DoSuba, DL, SearL, (inst & 7), DL, DR, Ca, 6, GRL, SRL)

Oper (Op9e00, DoSubB, DB, SdB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op9e10, DoSubB, DB, SainB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op9e18, DoSubB, DB, SaipB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op9e20, DoSubB, DB, SmaiB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op9e28, DoSubB, DB, SdaiB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op9e30, DoSubB, DB, SaixB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op9e38, DoSubB, DB, SearB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op9e40, DoSubW, DW, SdW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op9e48, DoSubW, DW, SaW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op9e50, DoSubW, DW, SainW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op9e58, DoSubW, DW, SaipW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op9e60, DoSubW, DW, SmaiW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op9e68, DoSubW, DW, SdaiW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op9e70, DoSubW, DW, SaixW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op9e78, DoSubW, DW, SearW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op9e80, DoSubL, DL, SdL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op9e88, DoSubL, DL, SaL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op9e90, DoSubL, DL, SainL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op9e98, DoSubL, DL, SaipL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op9ea0, DoSubL, DL, SmaiL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op9ea8, DoSubL, DL, SdaiL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op9eb0, DoSubL, DL, SaixL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op9eb8, DoSubL, DL, SearL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op9ec0, DoSuba, DL, SdW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9ec8, DoSuba, DL, SaW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9ed0, DoSuba, DL, SainW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9ed8, DoSuba, DL, SaipW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9ee0, DoSuba, DL, SmaiW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9ee8, DoSuba, DL, SdaiW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9ef0, DoSuba, DL, SaixW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9ef8, DoSuba, DL, SearW, (inst & 7), DL, DR, Ca, 7, GRL, SRL)

Oper (Op9f00, DoSubx, DB, SdB, (inst & 7), DB, DR, Cd, 7, GRB, SRB)
Oper (Op9f08, DoSubx, DB, SmaiB, (inst & 7), DB, DA, CmaiB15, 7, GMB, SMB)
Oper (Op9f10, DoSubB, DB, SdB, 7, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op9f18, DoSubB, DB, SdB, 7, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op9f20, DoSubB, DB, SdB, 7, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op9f28, DoSubB, DB, SdB, 7, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op9f30, DoSubB, DB, SdB, 7, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op9f38, DoSubB, DB, SdB, 7, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op9f40, DoSubx, DW, SdW, (inst & 7), DW, DR, Cd, 7, GRW, SRW)
Oper (Op9f48, DoSubx, DW, SmaiW, (inst & 7), DW, DA, CmaiW, 7, GMW, SMW)
Oper (Op9f50, DoSubW, DW, SdW, 7, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op9f58, DoSubW, DW, SdW, 7, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op9f60, DoSubW, DW, SdW, 7, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op9f68, DoSubW, DW, SdW, 7, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op9f70, DoSubW, DW, SdW, 7, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op9f78, DoSubW, DW, SdW, 7, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op9f80, DoSubx, DL, SdL, (inst & 7), DL, DR, Cd, 7, GRL, SRL)
Oper (Op9f88, DoSubx, DL, SmaiL, (inst & 7), DL, DA, CmaiL, 7, GML, SML)
Oper (Op9f90, DoSubL, DL, SdL, 7, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op9f98, DoSubL, DL, SdL, 7, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op9fa0, DoSubL, DL, SdL, 7, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op9fa8, DoSubL, DL, SdL, 7, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op9fb0, DoSubL, DL, SdL, 7, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op9fb8, DoSubL, DL, SdL, 7, DL, DA, Ceaw, (inst & 7), GML, SML)
Oper (Op9fc0, DoSuba, DL, SdL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9fc8, DoSuba, DL, SaL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9fd0, DoSuba, DL, SainL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9fd8, DoSuba, DL, SaipL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9fe0, DoSuba, DL, SmaiL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9fe8, DoSuba, DL, SdaiL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9ff0, DoSuba, DL, SaixL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)
Oper (Op9ff8, DoSuba, DL, SearL, (inst & 7), DL, DR, Ca, 7, GRL, SRL)

Oper (Op0400, DoSubB, DB, SimmB, 0, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op0410, DoSubB, DB, SimmB, 0, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op0418, DoSubB, DB, SimmB, 0, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op0420, DoSubB, DB, SimmB, 0, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op0428, DoSubB, DB, SimmB, 0, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op0430, DoSubB, DB, SimmB, 0, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op0438, DoSubB, DB, SimmB, 0, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op0440, DoSubW, DW, SimmW, 0, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op0450, DoSubW, DW, SimmW, 0, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op0458, DoSubW, DW, SimmW, 0, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op0460, DoSubW, DW, SimmW, 0, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op0468, DoSubW, DW, SimmW, 0, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op0470, DoSubW, DW, SimmW, 0, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op0478, DoSubW, DW, SimmW, 0, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op0480, DoSubL, DL, SimmL, 0, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op0490, DoSubL, DL, SimmL, 0, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op0498, DoSubL, DL, SimmL, 0, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op04a0, DoSubL, DL, SimmL, 0, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op04a8, DoSubL, DL, SimmL, 0, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op04b0, DoSubL, DL, SimmL, 0, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op04b8, DoSubL, DL, SimmL, 0, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5100, DoSubB, DB, Ss, 8, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5110, DoSubB, DB, Ss, 8, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5118, DoSubB, DB, Ss, 8, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5120, DoSubB, DB, Ss, 8, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5128, DoSubB, DB, Ss, 8, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5130, DoSubB, DB, Ss, 8, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5138, DoSubB, DB, Ss, 8, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5140, DoSubW, DW, Ss, 8, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5148, DoSuba, DL, Ss, 8, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5150, DoSubW, DW, Ss, 8, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5158, DoSubW, DW, Ss, 8, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5160, DoSubW, DW, Ss, 8, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5168, DoSubW, DW, Ss, 8, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5170, DoSubW, DW, Ss, 8, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5178, DoSubW, DW, Ss, 8, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5180, DoSubL, DL, Ss, 8, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5188, DoSuba, DL, Ss, 8, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5190, DoSubL, DL, Ss, 8, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5198, DoSubL, DL, Ss, 8, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op51a0, DoSubL, DL, Ss, 8, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op51a8, DoSubL, DL, Ss, 8, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op51b0, DoSubL, DL, Ss, 8, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op51b8, DoSubL, DL, Ss, 8, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5300, DoSubB, DB, Ss, 1, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5310, DoSubB, DB, Ss, 1, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5318, DoSubB, DB, Ss, 1, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5320, DoSubB, DB, Ss, 1, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5328, DoSubB, DB, Ss, 1, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5330, DoSubB, DB, Ss, 1, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5338, DoSubB, DB, Ss, 1, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5340, DoSubW, DW, Ss, 1, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5348, DoSuba, DL, Ss, 1, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5350, DoSubW, DW, Ss, 1, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5358, DoSubW, DW, Ss, 1, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5360, DoSubW, DW, Ss, 1, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5368, DoSubW, DW, Ss, 1, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5370, DoSubW, DW, Ss, 1, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5378, DoSubW, DW, Ss, 1, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5380, DoSubL, DL, Ss, 1, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5388, DoSuba, DL, Ss, 1, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5390, DoSubL, DL, Ss, 1, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5398, DoSubL, DL, Ss, 1, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op53a0, DoSubL, DL, Ss, 1, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op53a8, DoSubL, DL, Ss, 1, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op53b0, DoSubL, DL, Ss, 1, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op53b8, DoSubL, DL, Ss, 1, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5500, DoSubB, DB, Ss, 2, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5510, DoSubB, DB, Ss, 2, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5518, DoSubB, DB, Ss, 2, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5520, DoSubB, DB, Ss, 2, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5528, DoSubB, DB, Ss, 2, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5530, DoSubB, DB, Ss, 2, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5538, DoSubB, DB, Ss, 2, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5540, DoSubW, DW, Ss, 2, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5548, DoSuba, DL, Ss, 2, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5550, DoSubW, DW, Ss, 2, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5558, DoSubW, DW, Ss, 2, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5560, DoSubW, DW, Ss, 2, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5568, DoSubW, DW, Ss, 2, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5570, DoSubW, DW, Ss, 2, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5578, DoSubW, DW, Ss, 2, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5580, DoSubL, DL, Ss, 2, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5588, DoSuba, DL, Ss, 2, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5590, DoSubL, DL, Ss, 2, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5598, DoSubL, DL, Ss, 2, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op55a0, DoSubL, DL, Ss, 2, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op55a8, DoSubL, DL, Ss, 2, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op55b0, DoSubL, DL, Ss, 2, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op55b8, DoSubL, DL, Ss, 2, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5700, DoSubB, DB, Ss, 3, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5710, DoSubB, DB, Ss, 3, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5718, DoSubB, DB, Ss, 3, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5720, DoSubB, DB, Ss, 3, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5728, DoSubB, DB, Ss, 3, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5730, DoSubB, DB, Ss, 3, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5738, DoSubB, DB, Ss, 3, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5740, DoSubW, DW, Ss, 3, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5748, DoSuba, DL, Ss, 3, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5750, DoSubW, DW, Ss, 3, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5758, DoSubW, DW, Ss, 3, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5760, DoSubW, DW, Ss, 3, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5768, DoSubW, DW, Ss, 3, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5770, DoSubW, DW, Ss, 3, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5778, DoSubW, DW, Ss, 3, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5780, DoSubL, DL, Ss, 3, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5788, DoSuba, DL, Ss, 3, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5790, DoSubL, DL, Ss, 3, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5798, DoSubL, DL, Ss, 3, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op57a0, DoSubL, DL, Ss, 3, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op57a8, DoSubL, DL, Ss, 3, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op57b0, DoSubL, DL, Ss, 3, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op57b8, DoSubL, DL, Ss, 3, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5900, DoSubB, DB, Ss, 4, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5910, DoSubB, DB, Ss, 4, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5918, DoSubB, DB, Ss, 4, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5920, DoSubB, DB, Ss, 4, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5928, DoSubB, DB, Ss, 4, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5930, DoSubB, DB, Ss, 4, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5938, DoSubB, DB, Ss, 4, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5940, DoSubW, DW, Ss, 4, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5948, DoSuba, DL, Ss, 4, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5950, DoSubW, DW, Ss, 4, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5958, DoSubW, DW, Ss, 4, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5960, DoSubW, DW, Ss, 4, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5968, DoSubW, DW, Ss, 4, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5970, DoSubW, DW, Ss, 4, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5978, DoSubW, DW, Ss, 4, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5980, DoSubL, DL, Ss, 4, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5988, DoSuba, DL, Ss, 4, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5990, DoSubL, DL, Ss, 4, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5998, DoSubL, DL, Ss, 4, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op59a0, DoSubL, DL, Ss, 4, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op59a8, DoSubL, DL, Ss, 4, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op59b0, DoSubL, DL, Ss, 4, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op59b8, DoSubL, DL, Ss, 4, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5b00, DoSubB, DB, Ss, 5, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5b10, DoSubB, DB, Ss, 5, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5b18, DoSubB, DB, Ss, 5, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5b20, DoSubB, DB, Ss, 5, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5b28, DoSubB, DB, Ss, 5, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5b30, DoSubB, DB, Ss, 5, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5b38, DoSubB, DB, Ss, 5, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5b40, DoSubW, DW, Ss, 5, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5b48, DoSuba, DL, Ss, 5, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5b50, DoSubW, DW, Ss, 5, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5b58, DoSubW, DW, Ss, 5, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5b60, DoSubW, DW, Ss, 5, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5b68, DoSubW, DW, Ss, 5, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5b70, DoSubW, DW, Ss, 5, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5b78, DoSubW, DW, Ss, 5, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5b80, DoSubL, DL, Ss, 5, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5b88, DoSuba, DL, Ss, 5, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5b90, DoSubL, DL, Ss, 5, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5b98, DoSubL, DL, Ss, 5, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op5ba0, DoSubL, DL, Ss, 5, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op5ba8, DoSubL, DL, Ss, 5, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op5bb0, DoSubL, DL, Ss, 5, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op5bb8, DoSubL, DL, Ss, 5, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5d00, DoSubB, DB, Ss, 6, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5d10, DoSubB, DB, Ss, 6, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5d18, DoSubB, DB, Ss, 6, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5d20, DoSubB, DB, Ss, 6, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5d28, DoSubB, DB, Ss, 6, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5d30, DoSubB, DB, Ss, 6, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5d38, DoSubB, DB, Ss, 6, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5d40, DoSubW, DW, Ss, 6, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5d48, DoSuba, DL, Ss, 6, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5d50, DoSubW, DW, Ss, 6, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5d58, DoSubW, DW, Ss, 6, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5d60, DoSubW, DW, Ss, 6, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5d68, DoSubW, DW, Ss, 6, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5d70, DoSubW, DW, Ss, 6, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5d78, DoSubW, DW, Ss, 6, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5d80, DoSubL, DL, Ss, 6, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5d88, DoSuba, DL, Ss, 6, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5d90, DoSubL, DL, Ss, 6, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5d98, DoSubL, DL, Ss, 6, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op5da0, DoSubL, DL, Ss, 6, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op5da8, DoSubL, DL, Ss, 6, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op5db0, DoSubL, DL, Ss, 6, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op5db8, DoSubL, DL, Ss, 6, DL, DA, Ceaw, (inst & 7), GML, SML)

Oper (Op5f00, DoSubB, DB, Ss, 7, DB, DR, Cd, (inst & 7), GRB, SRB)
Oper (Op5f10, DoSubB, DB, Ss, 7, DB, DA, Cain, (inst & 7), GMB, SMB)
Oper (Op5f18, DoSubB, DB, Ss, 7, DB, DA, CaipB, (inst & 7), GMB, SMB)
Oper (Op5f20, DoSubB, DB, Ss, 7, DB, DA, CmaiB, (inst & 7), GMB, SMB)
Oper (Op5f28, DoSubB, DB, Ss, 7, DB, DA, Cdai, (inst & 7), GMB, SMB)
Oper (Op5f30, DoSubB, DB, Ss, 7, DB, DA, Caix, (inst & 7), GMB, SMB)
Oper (Op5f38, DoSubB, DB, Ss, 7, DB, DA, Ceaw, (inst & 7), GMB, SMB)
Oper (Op5f40, DoSubW, DW, Ss, 7, DW, DR, Cd, (inst & 7), GRW, SRW)
Oper (Op5f48, DoSuba, DL, Ss, 7, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5f50, DoSubW, DW, Ss, 7, DW, DA, Cain, (inst & 7), GMW, SMW)
Oper (Op5f58, DoSubW, DW, Ss, 7, DW, DA, CaipW, (inst & 7), GMW, SMW)
Oper (Op5f60, DoSubW, DW, Ss, 7, DW, DA, CmaiW, (inst & 7), GMW, SMW)
Oper (Op5f68, DoSubW, DW, Ss, 7, DW, DA, Cdai, (inst & 7), GMW, SMW)
Oper (Op5f70, DoSubW, DW, Ss, 7, DW, DA, Caix, (inst & 7), GMW, SMW)
Oper (Op5f78, DoSubW, DW, Ss, 7, DW, DA, Ceaw, (inst & 7), GMW, SMW)
Oper (Op5f80, DoSubL, DL, Ss, 7, DL, DR, Cd, (inst & 7), GRL, SRL)
Oper (Op5f88, DoSuba, DL, Ss, 7, DL, DR, Ca, (inst & 7), GRL, SRL)
Oper (Op5f90, DoSubL, DL, Ss, 7, DL, DA, Cain, (inst & 7), GML, SML)
Oper (Op5f98, DoSubL, DL, Ss, 7, DL, DA, CaipL, (inst & 7), GML, SML)
Oper (Op5fa0, DoSubL, DL, Ss, 7, DL, DA, CmaiL, (inst & 7), GML, SML)
Oper (Op5fa8, DoSubL, DL, Ss, 7, DL, DA, Cdai, (inst & 7), GML, SML)
Oper (Op5fb0, DoSubL, DL, Ss, 7, DL, DA, Caix, (inst & 7), GML, SML)
Oper (Op5fb8, DoSubL, DL, Ss, 7, DL, DA, Ceaw, (inst & 7), GML, SML)
